package com.ejie.ab04b.dao.temp;

import java.util.List;

import com.ejie.ab04b.model.DocumentoAperturas;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0465stempDao generated by UDA, 29-jun-2017 10:57:16.
 * 
 * @author UDA
 */

public interface DocumentosAperturasTempDao {

	/**
	 * Inserts a single row in the Ab0465stemp table.
	 * 
	 *  ab0465stemp
	 *            Ab0465stemp
	 *  Ab0465stemp
	 *
	 * @param ab0465stemp the ab 0465 stemp
	 * @return the documento aperturas
	 */
	DocumentoAperturas add(DocumentoAperturas ab0465stemp);

	/**
	 * Updates a single row in the Ab0465stemp table.
	 * 
	 *  ab0465stemp
	 *            Ab0465stemp
	 *  Ab0465stemp
	 *
	 * @param ab0465stemp the ab 0465 stemp
	 * @return the documento aperturas
	 */
	DocumentoAperturas update(DocumentoAperturas ab0465stemp);

	/**
	 * Finds a single row in the Ab0465stemp table.
	 * 
	 *  ab0465stemp
	 *            Ab0465stemp
	 *  Ab0465stemp
	 *
	 * @param ab0465stemp the ab 0465 stemp
	 * @return the documento aperturas
	 */
	DocumentoAperturas find(DocumentoAperturas ab0465stemp);

	/**
	 * Removes a single row in the Ab0465stemp table.
	 * 
	 *  ab0465stemp
	 *            Ab0465stemp
	 *
	 * @param ab0465stemp the ab 0465 stemp
	 */
	void remove(DocumentoAperturas ab0465stemp);

	/**
	 * Removes a single row in the Ab0465stemp table.
	 * 
	 *  ab0465stemp
	 *            Ab0465stemp
	 *
	 * @param ab0465stemp the ab 0465 stemp
	 */
	void removeByIdApertura(DocumentoAperturas ab0465stemp);

	/**
	 * Finds a List of rows in the Ab0465stemp table.
	 * 
	 *  ab0465stemp
	 *            Ab0465stemp
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List
	 *
	 * @param ab0465stemp the ab 0465 stemp
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<DocumentoAperturas> findAll(DocumentoAperturas ab0465stemp,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Ab0465stemp table using like.
	 * 
	 *  ab0465stemp
	 *            Ab0465stemp
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List
	 *
	 * @param ab0465stemp the ab 0465 stemp
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<DocumentoAperturas> findAllLike(DocumentoAperturas ab0465stemp,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0465stemp table using like.
	 * 
	 *  ab0465stemp
	 *            Ab0465stemp
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param ab0465stemp the ab 0465 stemp
	 * @param startsWith the starts with
	 * @return the long
	 */
	Long findAllLikeCount(DocumentoAperturas ab0465stemp, Boolean startsWith);

	/**
	 * Counts rows in the Ab0465stemp table.
	 * 
	 *  ab0465stemp
	 *            Ab0465stemp
	 *  Long
	 *
	 * @param ab0465stemp the ab 0465 stemp
	 * @return the long
	 */
	Long findAllCount(DocumentoAperturas ab0465stemp);

	/**
	 * Reorder selection.
	 * 
	 *  filterAb0465stemp
	 *            Ab0465stemp
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0465stemp>>
	 *
	 * @param filterAb0465stemp the filter ab 0465 stemp
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<DocumentoAperturas>> reorderSelection(
			DocumentoAperturas filterAb0465stemp,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 * 
	 *  filterAb0465stemp
	 *            Ab0465stemp
	 *  searchAb0465stemp
	 *            Ab0465stemp
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0465stemp>>
	 *
	 * @param filterAb0465stemp the filter ab 0465 stemp
	 * @param searchAb0465stemp the search ab 0465 stemp
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<DocumentoAperturas>> search(
			DocumentoAperturas filterAb0465stemp,
			DocumentoAperturas searchAb0465stemp,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Busca documentos con el mismo nombre de fichero (sin tener en cuenta
	 * mayúsculas/minúsculas ni la extensión)
	 * 
	 *  documento
	 *            SolicDocAperturas
	 * 
	 *  List<SolicDocAperturas>.
	 *
	 * @param documento the documento
	 * @return the list
	 */
	List<DocumentoAperturas> buscarDocumentosAperturasTempTipo(
			DocumentoAperturas documento);
		
	/**
	 * Busca documentos con el mismo nombre de fichero (sin tener en cuenta
	 * mayúsculas/minúsculas ni la extensión)
	 * 
	 *  documento
	 *            SolicDocAperturas
	 * 
	 *  List<SolicDocAperturas>.
	 *
	 * @param documento the documento
	 * @return the list
	 */
	List<DocumentoAperturas> buscarDocumentosAperturasInspeccion(
			DocumentoAperturas documento);
	

	/**
	 * Busca documentos con el mismo nombre de fichero (sin tener en cuenta
	 * mayúsculas/minúsculas ni la extensión)
	 * 
	 *  documento
	 *            SolicDocAperturas
	 * 
	 *  List<SolicDocAperturas>.
	 *
	 * @param documento the documento
	 * @return the list
	 */
	List<DocumentoAperturas> buscarDocumentosAperturasTempIdApe(
			DocumentoAperturas documento);
	
	/**
	 * Finds a list of rows in the SolicDocumentos table.
	 * 
	 *  solicdocumentos
	 *            SolicDocumentos
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<SolicDocumentos>
	 *
	 * @param solicdocumentos the solicdocumentos
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<DocumentoAperturas> buscarPorIdApeYMetadatoNombre(
			DocumentoAperturas solicdocumentos,
			JQGridRequestDto jqGridRequestDto);
}
